##############################################################################
#
#  Palm-FE Palm Pilot Functional Emulator
#  (c) Vladi Belperchinov-Shabanski "Cade" 2000-2001 
#  <cade@biscom.net> <cade@datamax.bg>
#
#  DISTRIBUTED UNDER GPL LICENSE, SEE `COPYING' FILE FOR DETAILS
#
##############################################################################
package p3_conf;
use Exporter;
use strict;
our @ISA    = qw( Exporter );
our @EXPORT = qw( $ROOT $CATFILE $THEME $LANG $MODULES $IDLE
              $BGC $FGC $ACC $TC1 $TC2 $HEC
              $USER $SESS $SCR $MODE $MODULE $WWWPATH $CAT
              %SDA %CATS %MODULES @MODULES $SDAFILE @MODULES_FIND
              @HTML_INC $TRANSLATION
              %PREFS $PREFSFILE
              $DEBUG );


#############################################################################
#
# STATIC CONFIGURATION (EDIT IF NEEDED)
#
#############################################################################
#
# $ROOT is the only thing that must be changed, the rest are optional
#
# this is set in the first line of palm3.pl:
# #!/usr/bin/perl -I/home/cade/pro/palm-fe3/pro
our $ROOT = $INC[0];
our $ROOT =~ s/\/pro$//i; # trim trailing `/pro' string

# if the line above fails or does not work properly you can override it:
#$ROOT    = "/home/cade/pro/palm-fe3"; # palm-fe root directory location

#############################################################################
#
# theme name -- actually this is directory name under  $ROOT/themes which
# contains all required images and colors
#
our $THEME   = "default";     # theme name


#############################################################################
#
# language to be used -- currently there is no language support
# however since almost all controls (buttons) are images, language support
# can be done with theme
#
our $LANG    = "en";          # language (not used, supported via themes below)

#############################################################################
#
# idle time in minutes for session expiration
#
our $IDLE    = 20;

#############################################################################
#
# categories file name, actually there is no reason for changing this one
#
our $CATFILE = "categories";  

#############################################################################
#
# where to look for images, usually this should point to web-visible,
# theme directory. if left blank -- palm-fe will use dynamic images
# i.e. will pipe them through itself
#
# usually it is safe to leave it blank, the only reason for static images
# is performance and caching
#
# `static' images:
#$WWWPATH = "/~cade/palm3/themes";
#
# `dynamic (piped)' images:
#our $WWWPATH = "";
#
# automatic:
our $WWWPATH = $ENV{ SCRIPT_NAME };
$WWWPATH =~ s/\/[^\/]+$/\//;
$WWWPATH .= 'themes';

#############################################################################
#
# this tells the bottom-line menu order
#
our @MODULES = qw( Home Address Memo Todo Calc Find Prefs );

#############################################################################
#
# this tells which modules' data can be searched
#
our @MODULES_FIND = qw( Address Memo Todo );

#############################################################################
#
# search dirs for html templates
#
our @HTML_INC = ( "$ROOT/inc" );

#############################################################################
#
# translation
#
our $TRANSLATION = {};

#############################################################################
#
# RUN-TIME CONFIGURATION (WILL BE MODIFIED RUN-TIME, DO NOT EDIT BELOW)
#
#############################################################################

our $DEBUG = 0;

our %MODULES;

#############################################################################
#
# colors
#
our $BGC = "#7b8c5a"; # background
our $FGC = "#000000"; # foreground
our $ACC = "#ffffff"; # active color
our $TC1 = "#9bac7a"; # table rows color 1
our $TC2 = "#abbc8a"; # table rows color 2
our $HEC = "#cbdc9a"; # header color (tables)

our $USER = "";       # username 
our $SESS = "";       # session id
our $SCR  = "";       # current script url (with session)

our $MODE = "";       # current (active) mode (module)
our $MODULE = "";     # current module file name

our %SDA  = ();       # session data
our $SDAFILE = "";    # session data file name

our $CAT  = "";       # currently selected category
our %CATS = ();       # categories

our %PREFS = ();      # preferences
our $PREFSFILE = "";  # preferences file

#############################################################################
#
# EOF
#
#############################################################################
1;

