package p3_main;
#!/usr/bin/perl -I/home/cade/work/palm-fe3/pro
##############################################################################
#
#  Palm-FE Palm Pilot Functional Emulator
#  (c) Vladi Belperchinov-Shabanski "Cade" 2000-2001
#  <cade@biscom.net> <cade@datamax.bg>
#
#  DISTRIBUTED UNDER GPL LICENSE, SEE `COPYING' FILE FOR DETAILS
#
#  additional credits here...
#
#
#
#
#
#
#
#
##############################################################################
use CGI;
use p3_ses;
use p3_conf;
use p3_uti;
use strict;

sub main
{
  ### DEBUG ##################################################################
  
  debug("root: $ROOT");
  
  ### DYNAMIC IMAGES HACK HERE ###############################################
  
  my $pipeimg = CGI::param( "pipeimg" );
  return pipe_image( $pipeimg ) if $pipeimg;
  
  ### PROGRAMM STARTS HERE / INITIAL SETUP ###################################

  check_dir( "$ROOT/data/sessions/" );
  
  my $errors = undef;
  
  $USER = http_user( PWD_FILE  => "$ROOT/data/passwd",
                     DOMAIN    => "Palm-FE 3",
                     SES_PATH  => "$ROOT/data/sessions/",
                     IDLE_TIME => $IDLE*60 );
  $SESS = http_sid();
  $SCR  = $ENV{ 'SCRIPT_NAME' };

  debug("user: $USER, session: $SESS");
  
  ### LOAD CGI PARAMETERS ####################################################
  
  $SDAFILE = "$ROOT/data/sessions/http_ses_$SESS";
  
  load_hash( $SDAFILE, \%SDA );
  for( keys %SDA )
    {
    delete $SDA{ $_ } if /^in_/;
    }
  for( CGI::param() )
    {
    my $value = CGI::param( $_ );
    next if $value =~ /^\s*$/; # skip empty (whitespace only) values
    $value =~ s/[\0]//g;
    $value =~ s/[\[\<]/\(/g;
    $value =~ s/[\]\>]/\)/g;
    $value =~ s/'/`/g;
    $SDA{ "in_" . $_ } = $value;
    }
  
  ### PRESERVE SPECIALS ###
  $SDA{ "mode" } = $SDA{ "in_mode" } if $SDA{ "in_mode" };
  $SDA{ "cat" }  = $SDA{ "in_cat" }  if $SDA{ "in_cat" };
  
  ### FILL DEFAULTS + VALIDATE ###
  $SDA{ "mode" } = "Welcome" unless $SDA{ "mode" };
  $SDA{ "cat" }  = "Unified" unless $SDA{ "cat"  };
  
  $errors .= "Invalid ID<br>" unless $SDA{ "in_id" } =~ /^\d*$/;
  $errors .= "Invalid MODE name<br>" unless $SDA{ "mode" } =~ /^[a-z_0-9]+$/i;
  
  $CAT  = $SDA{ "cat" };
  $MODE = $SDA{ "mode" };
  $MODULE = lc "p3_mod_$MODE";
  
  save_hash( $SDAFILE, \%SDA );
  
  ############################################################################
  
  load_module( $MODE );
  $errors .= "Module not available (not implemented): $MODE<br>" unless $MODULES{ "\u\L$MODE" };
  
  check_dir( "$ROOT/data/users" );
  $errors .= "Cannot access DATA directory<br>" unless chdir( "$ROOT/data/users" );
  check_dir( "$ROOT/data/users/$USER" );
  $errors .= "Cannot access USER directory<br>" unless chdir( "$USER" );
  check_dir( "$ROOT/data/users/$USER/$MODE" );
  $errors .= "Cannot access MODE directory<br>" unless chdir( "$MODE" );
  check_dir( "$ROOT/data/users/$USER/$MODE/deleted" );
  
  load_hash( $CATFILE, \%CATS );
  
  ### PREFERENCES (LOAD DEFAULTS) ###
  
  $PREFSFILE = "$ROOT/data/users/$USER/preferences";
  load_hash( $PREFSFILE, \%PREFS );
  
  if( $SDA{ "in_cat" } )
    {
    $PREFS{ "last.$MODE.cat" } = $CAT = $SDA{ "in_cat" };
    }
  else
    {
    $CAT = $PREFS{ "last.$MODE.cat" } || "Unfiled";
    }
  
  ############################################################################
  
  my $text;
  
  $text .= fmt_header( $MODE );
  if ( $errors )
    {
    $text .= "<center><code><b>ERRORS:<br>$errors</b></code></center><br>";
    }
  else
    {
    load_hash( $CATFILE, \%CATS );
    if ( $CAT =~ /^Edit/ )
      {
      $text .= edit_categories();
      }
    else
      {
      $text .= $MODULE->main();
      save_hash( $SDAFILE, \%SDA ); # in case module saved own data
      save_hash( $PREFSFILE, \%PREFS ); # opt's
      }
    }
  $text .= fmt_footer();
  
  return html_expand( $text );
}

1;
###EOF########################################################################

