##############################################################################
#
#  Palm-FE Palm Pilot Functional Emulator
#  (c) Vladi Belperchinov-Shabanski "Cade" 2000-2001 
#  <cade@biscom.net> <cade@datamax.bg>
#
#  DISTRIBUTED UNDER GPL LICENSE, SEE `COPYING' FILE FOR DETAILS
#
##############################################################################
package p3_mod_address;
use p3_ses;
use p3_conf;
use p3_uti;
use Exporter;
@ISA    = qw( Exporter );
@EXPORT = qw( main );
use strict;

our %OPT = ( 
             cats => 1,                  # this modules uses categories
           );

sub main
{
  my    $act = $SDA{ "in_act" };
  if    ( $act eq "form" )   { form_item()   }
  elsif ( $act eq "update" ) { update_item() }
  elsif ( $act eq "delete" ) { delete_item() }
  elsif ( $act eq "view" )   { view_item()   }
  else  { list_items() }
};

##############################################################################

sub form_item
{
  my $text;
  
  my $id = $SDA{ "in_id" };
  
  my %data = ();
  
  load_hash( $id, \%data );

  my @td;

  my $cats_list = get_cats_option_list( $data{ category } );

  push @td, [ "[!width=30% align=right]Attribute", "[!width=70%]Value" ];
  push @td, [ "Name:", 
              "<input name=name value='$data{name}' size=40>" ];
  push @td, [ "Position:",
              "<input name=position value='$data{position}' size=40>" ];            
  push @td, [ "Company:",
              "<input name=company value='$data{company}' size=40>" ];
  push @td, [ "Work telephone#:",
              "<input name=work value='$data{work}' size=40>" ];
  push @td, [ "Home telephone#:",
              "<input name=home value='$data{home}' size=40>" ];
  push @td, [ "FAX #:",
              "<input name=fax value='$data{fax}' size=40>" ];            
  push @td, [ "Other/Mobile telephone#:",
              "<input name=other value='$data{other}' size=40>" ];
  push @td, [ "E-Mail address:",
              "<input name=email value='$data{email}' size=40>" ];
  push @td, [ "Address:",
              "<textarea name=address rows=3 cols=40>$data{address}</textarea>" ];            
  push @td, [ "Category:", 
              "<b><select name=category>$cats_list</select>" ];
  push @td, [ "Notes:",
              "<textarea name=note rows=5 cols=40>$data{note}</textarea>" ];
  
  my $cancel = $id == 0 ? "act=list" : "act=view&id=$id";
  $text .= "
    <center>
    <form action=$SCR?>
    <input type=hidden name=id   value=$id>
    <input type=hidden name=act  value=update>"
    . html_format_table( \@td, opt => "width=80% cellspacing=1" ) .
    "
    <hr noshade size=1 width=80%>
    <input type=submit value='  Done  ' class=button>
    <a href='?$cancel' class=button> Cancel </a>
    <a href='?act=delete&id=$id' class=button> Delete </a>
    </form>
    ";

  return $text;
};

##############################################################################

sub update_item
{
  my $id = $SDA{ "in_id" };
  $id = new_id() if $id == 0;

  my %data;
  for( qw( name position company work home fax other email address category note ) )
    {
    $data{ $_ } = $SDA{ "in_$_" };
    }
  $data{ "name" } ||= '[unnamed]';
  $data{ "find_title" } = $data{ name }; # see find module notes!
  save_hash( $id, \%data );

  $SDA{ "in_id" } = $id;
  return view_item();
};

##############################################################################

sub delete_item
{
  my $id = $SDA{ "in_id" };
  system( "mv $id deleted/$id" );
  return list_items();
};

##############################################################################

sub list_items
{
  my $text;

  my @td;
  push @td, [ "[!width=55%]Name", "[!width=15%]Category", "[!width=15%]Work#", "[!width=15%]Home#" ];
  
  for( load_dir( ".", "[0-9].*" ) )
    {
    my $id = $_;
    my %data;
    load_hash( $id, \%data );

    if ( $CAT ne "All" )
      {
      if ( $data{ category } ne $CAT ) { next };
      }
    my $note_reminder = rtf_note_reminder( $data{note} );
    
    my $mail_str;
    for( split /[\s\,]+/, $data{email} )
      { $mail_str .= "<a href='mailto:$_' title=$_><-img:mail2></a>"; }

    my $cat_e = CGI::escape( $data{ category } );
    my $cat_link = "<a href=?act=list&cat=$cat_e>$data{ category }</a>";

    my $name = $data{name} || '[unnamed]';
    
    my $co_str = "&nbsp;/ <b>$data{company}</b>" if $data{company};
    push @td, [ "<a href=?act=view&id=$id><b>$name</b></a> $mail_str
                 $co_str<font size=-1>$note_reminder</font>",
                 $cat_link,
                "<b>$data{work}", 
                "<b>$data{home}" ];
    }

  $text .= html_format_table( \@td, opt => 'width=100% cellspacing=1' ) . "
    <p>
    <hr noshade size=1 width=80%>
    <center>
    <a href=$SCR?act=form&id=0 class=button>  New  </a>
    </center>
  ";

  return $text;
};

##############################################################################

sub view_item
{
  my $text;
  
  my $id = $SDA{ "in_id" };
  
  my %data;
  load_hash( $id, \%data );

  my $notes = rtf_text( $data{note} );

  my $mail_str;
  for( split /\s+/, $data{email} )
    { $mail_str .= "<a href='mailto:$_'>$_</a> "; }

  my @td;
  
  push @td, [ "[!width=30% align=right]", "[!width=70%]Category: $data{category}" ];
  push @td, [ "Name:",           "<b>$data{name}" ];
  push @td, [ "Position:",       "<b>$data{position}" ];
  push @td, [ "Company:",        "<b>$data{company}" ];
  push @td, [ "Work telephone:", "<b>$data{work}" ];
  push @td, [ "Home telephone:", "<b>$data{home}" ];
  push @td, [ "Fax number:",     "<b>$data{fax}" ];
  push @td, [ "Other/Mobile telephone:", "<b>$data{other}" ];
  push @td, [ "E-Mail address:", "<b>$mail_str" ];
  push @td, [ "Address:",        "<b>$data{address}" ];
  push @td, [ "Notes:",          "<pre>$notes" ];

  $text .= "
    <center>"
    . html_format_table( \@td, opt => "width=80% cellspacing=1" ) .
    "
    <hr noshade size=1 width=80%>
    <a href='?act=list' class=button>   Ok   </a>
    <a href='?act=form&id=$id' class=button>  Edit  </a>
    ";
  
  return $text;
};



1;
