##############################################################################
#
#  Palm-FE Palm Pilot Functional Emulator
#  (c) Vladi Belperchinov-Shabanski "Cade" 2000-2001 
#  <cade@biscom.net> <cade@datamax.bg>
#
#  DISTRIBUTED UNDER GPL LICENSE, SEE `COPYING' FILE FOR DETAILS
#
##############################################################################
package p3_mod_calc;
use p3_ses;
use p3_conf;
use p3_uti;
use Exporter;
@ISA    = qw( Exporter );
@EXPORT = qw( main );
use strict;

sub main
{
  my $text;
  
  my $expr    = $SDA{ 'in_expr' };
  
  my %data;
  load_hash( '0', \%data );
  
  my $memory  = $data{ 'memory' };
  my $history = $data{ 'history' };
  
  $expr =~ s/[^\(\)0-9\.\-\+\/\*\\% ]//gio;
  
  my $res;
  eval( "\$res = $expr" );
  
  $data{ 'hist_row' } = !$data{ 'hist_row' };
  my $clr = $data{ 'hist_row' } ? $TC1 : $TC2;
  
  my $expr_e = CGI::escape( $expr );
  my $res_e  = CGI::escape( $res  );
  
  $history = "<tr bgcolor=$clr>
              <td widht=100%>&nbsp;<code><a href=?set_expr=$expr_e>$expr</a></code></td>
              <td width=1%><code>=</td>
              <td align=right>&nbsp;<code><a href=?set_expr=$res_e>$res</a></code></td></tr>" . $history if $expr;
  
  my $res2 = $res;
  
  $history = ""      if $SDA{ in_CH };
  $memory += $res    if $SDA{ in_MP };
  $memory -= $res    if $SDA{ in_MM };
  $memory  = $res    if $SDA{ in_MS };
  $res2    = $memory if $SDA{ in_MR };
  $memory = 0 unless $memory;
  $data{ 'history' } = $history;
  $data{ 'memory'  } = $memory;
  
  
  $res2 = $SDA{ in_set_expr } if $SDA{ in_set_expr };
  $text .=  "
      <form action=?>
      <br><b>Memory = $memory<br>Expression:</b>
      <small><code>( allowed chars are: 0123456789+-*/%() )</code></small>
      <p>
      <b>
        <input name=expr size=40 value='$res2'>
        <input type=submit value=Evaluate class=button>
        <input type=submit name=MP value=M+ class=button>
        <input type=submit name=MM value=M- class=button>
        <input type=submit name=MS value=M= class=button>
        <input type=submit name=MR value=MR class=button>
        <input type=submit name=CH value=Clear class=button>
      </b>
      </form>
      <p>
      <table width=50% cellspacing=1 cellpadding=4>$history</table>
      ";
  save_hash( '0', \%data );
  return $text;
};

1;
