##############################################################################
#
#  Palm-FE Palm Pilot Functional Emulator
#  (c) Vladi Belperchinov-Shabanski "Cade" 2000-2001 
#  <cade@biscom.net> <cade@datamax.bg>
#
#  DISTRIBUTED UNDER GPL LICENSE, SEE `COPYING' FILE FOR DETAILS
#
##############################################################################
package p3_mod_find;
use p3_ses;
use p3_conf;
use p3_uti;
use Exporter;
@ISA    = qw( Exporter );
@EXPORT = qw( main );

##############################################################################
#
#  find module requires all data to have `find_title' key which is used to
#  show results table
#
sub main
{
  my $text;

  my $query = $SDA{ "in_query" };
  my %query = ();
  for( split /\s+/, $query )
    { $query{ lc $_ } = 1; }
  my @query = keys %query;
  
  $text .= "<center><b>Search results for: " . join( " ", @query ) . "<br><br>";
  
  if ( $#query > -1 )
    {
    for( @MODULES_FIND )
      {
      next unless chdir( "$ROOT/data/users/$USER/$_" );
      
      my @td = ();
      my $modname = $_;
      push @td, [ "<a href=?mode=$modname><b>$modname</a>" ];
      
      for( load_dir( ".", "[0-9].*" ) )
        {
        my $id = $_;
        my %data;
        load_hash( $id, \%data );
        
        my $all;
        for( keys %data )
          { $all .= lc $data{ $_ }; }
        
        my $found = 1;
        for( @query )
          {
          if ( index( $all, $_ ) == -1 )
            {
            $found = 0;
            last;
            }
          }
        
        if ( $found )
          {
          my $spc = "&nbsp;" x 10;
          push @td, [ "$spc<a href=$SCR?mode=$modname&act=view&id=$id&cat=All>$data{ find_title }</a>" ];
          }
        }
      
      if ( $#td > 0 )
        { $text .= fmt_table( @td, { width => "80%" } ); }
      }
    }

  $text .= "<p><b>
    <form action=$SCR?>
      <input name=query size=40 value=''>
      <input type=submit value=Find>
    </form>
    </b>
    </center>
    ";
  
  return $text;
}

1;
