##############################################################################
#
#  Palm-FE Palm Pilot Functional Emulator
#  (c) Vladi Belperchinov-Shabanski "Cade" 2000-2001 
#  <cade@biscom.net> <cade@datamax.bg>
#
#  DISTRIBUTED UNDER GPL LICENSE, SEE `COPYING' FILE FOR DETAILS
#
##############################################################################
package p3_mod_memo;
use p3_ses;
use p3_conf;
use p3_uti;
use Exporter;
@ISA    = qw( Exporter );
@EXPORT = qw( main );
use strict;

our %OPT = ( 
             cats => 1,                  # this modules uses categories
           );

sub main
{
  my    $act = $SDA{ "in_act" };
  if    ( $act eq "form" )   { form_item()   }
  elsif ( $act eq "update" ) { update_item() }
  elsif ( $act eq "delete" ) { delete_item() }
  elsif ( $act eq "view" )   { view_item()   }
  else  { list_items() }
};

##############################################################################

sub form_item
{
  my $text;
  
  my $id = $SDA{ "in_id" };
  
  my %data = ();
  
  load_hash( $id, \%data );
  
  my @td;

  my $cats_list = get_cats_option_list( $data{ category } );
  
  push @td, [ "[!width=30% align=right]Attribute", "[!width=70%]Value" ];
  push @td, [ "<b>Title:", 
              "<input name=title value='$data{title}' size=50>" ];
  push @td, [ "<b>Category:", 
              "<b><select name=category><option>Unfiled</option>$cats_list</select>" ];
  push @td, [ "<b>Note:", 
              "<textarea name=note rows=10 cols=50>$data{note}</textarea>" ];

  my $cancel = $id == 0 ? "act=list" : "act=view&id=$id";
  $text .= "
    <center>
    <form action=$SCR?>
    <input type=hidden name=id   value=$id>
    <input type=hidden name=act  value=update>"
    . html_format_table( \@td, opt => "width=80% cellspacing=1" ) .
    "
    <hr noshade size=1 width=80%>
    <input type=submit value='  Done  ' class=button>
    <a href='?$cancel' class=button> Cancel </a>
    <a href='?act=delete&id=$id' class=button>  Delete  </a>
    </form>
    ";

  return $text;
};

##############################################################################

sub update_item
{
  my $id = $SDA{ "in_id" };
  $id = new_id() if $id == 0;

  my %data;
  for( qw( title category note ) )
    {
    $data{ $_ } = $SDA{ "in_$_" };
    }
  $data{ title } ||= "[unnamed]";
  $data{ "find_title" } = $data{ title }; # see find module notes!
  save_hash( $id, \%data );

  $SDA{ "in_id" } = $id;
  return view_item();
};

##############################################################################

sub delete_item
{
  my $id = $SDA{ "in_id" };
  system( "mv $id deleted/$id" );
  return list_items();
};

##############################################################################

sub list_items
{
  my $text;

  my @td;
  push @td, [ "[!width=5% align=right]Size", "[!width=75%]Title", "[!width=20%]Category" ];
  
  for( load_dir( ".", "[0-9].*" ) )
    {
    my $id = $_;
    my %data;
    load_hash( $id, \%data );

    next if $CAT ne "All" and $data{ category } ne $CAT;

    my $note_reminder = rtf_note_reminder( $data{note} );

    my $size = length( $data{note} );

    my $title = $data{title} || '[unnamed]';
    
    my $cat_e = CGI::escape( $data{ category } );
    my $cat_link = "<a href=?act=list&cat=$cat_e>$data{ category }</a>";
    push @td, [ "<b>$size</b>", 
                "<a href=?act=view&id=$id><b>$title</b></a>
                 <font size=-1>$note_reminder</font>",
                 $cat_link ];
    }

  $text .= html_format_table( \@td, opt => "width=100% cellspacing=1" ) . "
    <p>
    <hr noshade size=1 width=80%>
    <center>
    <a href=$SCR?act=form&id=0 class=button>  New  </a>
    </center>
  ";

  return $text;
};

##############################################################################

sub view_item
{
  my $text;
  
  my $id = $SDA{ "in_id" };
  
  my %data;
  load_hash( $id, \%data );

  my $notes = rtf_text( $data{note} );

  my @td;
  
  push @td, [ "[!width=50%]$data{title}", "[!width=50%]Category: $data{category}" ];
  push @td, [ "[!colspan=2]<pre>$notes</pre>" ];

  $text .= "<center>" . html_format_table( \@td, opt => "width=80% cellspacing=1" ) . 
   "<hr noshade size=1 width=80%>
    <a href='?act=list' class=button>   Ok   </a>
    <a href='?act=form&id=$id' class=button>  Edit  </a>
    </center>
    ";

  return $text;
};

1;
