##############################################################################
#
#  Palm-FE Palm Pilot Functional Emulator
#  (c) Vladi Belperchinov-Shabanski "Cade" 2000-2001 
#  <cade@biscom.net> <cade@datamax.bg>
#
#  DISTRIBUTED UNDER GPL LICENSE, SEE `COPYING' FILE FOR DETAILS
#
##############################################################################
package p3_mod_prefs;
use p3_ses;
use p3_conf;
use p3_uti;
use Exporter;
@ISA    = qw( Exporter );
@EXPORT = qw( main );
use strict;

sub main
{
  my    $act = $SDA{ "in_act" };
  if    ( $act eq "form" )   { form_item()   }
  elsif ( $act eq "update" ) { update_item() }
  else  { view_item() }
};

##############################################################################

sub form_item
{
  my $text;
  
  my @td;
  
  push @td, [ "<b>Name:", 
              "<input name=name value='$PREFS{name}' size=52>" ];
  push @td, [ "<b>Mobile (SMS) phone:", 
              "<input name=mobile value='$PREFS{mobile}' size=52>" ];
  push @td, [ "<b>Note:", 
              "<textarea name=note rows=10 cols=50>$PREFS{note}</textarea>" ];

  $text .= "
    <center>
    <form action=$SCR?>
    <input type=hidden name=act  value=update>"
    . fmt_table2( @td, { width => "80%", 
                         right1 => "hack",
                         cellpadding => 1 } ) .
    "
    <hr noshade size=1 width=80%>
    <-subimg:done>
    <a href='$SCR?act=view'><-img:cancel></a>
    </form>
    ";

  return $text;
};

##############################################################################

sub update_item
{
  for( qw( name mobile note ) )
    {
    $PREFS{ $_ } = $SDA{ "in_$_" };
    }
  save_hash( $PREFSFILE, \%PREFS );

  return view_item();
};

##############################################################################

sub view_item
{
  my $text;
  
  my @td;
  
  my $notes = rtf_text( $PREFS{note} );
  
  push @td, [ "<b>Option:", "+<b>Value" ];
  push @td, [ "<b>Name:", 
              "$PREFS{name}" ];
  push @td, [ "<b>Mobile (SMS) phone:", 
              "$PREFS{mobile}" ];
  push @td, [ "<b>Note:", 
              "<pre>$notes</pre>" ];
  
  $text .= "<center>" . fmt_table( @td, { width => "80%", right1 => "hack" } ) . 
   "<hr noshade size=1 width=80%>
    <a href='$SCR?act=form'><-img:edit></a>
    </center>
    ";

  return $text;
};

1;
