##############################################################################
#
#  Palm-FE Palm Pilot Functional Emulator
#  (c) Vladi Belperchinov-Shabanski "Cade" 2000-2001
#  <cade@biscom.net> <cade@datamax.bg>
#
#  DISTRIBUTED UNDER GPL LICENSE, SEE `COPYING' FILE FOR DETAILS
#
##############################################################################
package p3_mod_todo;
use p3_ses;
use p3_conf;
use p3_uti;
use Exporter;
@ISA    = qw( Exporter );
@EXPORT = qw( main );
use strict;

our %OPT = ( 
             cats => 1,                  # this modules uses categories
           );

sub main
{
  my    $act = $SDA{ "in_act" };
  if    ( $act eq "form" )   { form_item()   }
  elsif ( $act eq "update" ) { update_item() }
  elsif ( $act eq "delete" ) { delete_item() }
  elsif ( $act eq "view" )   { view_item()   }
  elsif ( $act eq "toggle" ) { toggle_item() }
  else  { list_items() }
};

##############################################################################

sub list_items
{
  my $text;

  my @td;
  push @td, [ "[!width=5% align=center]Done", "[!width=5% align=center]Pri", "[!width=60%]Title", "[!width=15%]Category</b>", "[!width=15%]DueDate" ];
  
  for( load_dir( ".", "[0-9].*" ) )
    {
    my $id = $_;
    my %data;
    load_hash( $id, \%data );

    if ( $CAT ne "All" )
      {
      if ( $data{ category } ne $CAT ) { next };
      }

    my $note_reminder = rtf_note_reminder( $data{note} );
  
    my $red;
    $red = "color=#cc0000" if $data{priority} == 6;
    $red = "" if $data{done} eq "Yes";
    my $duedays;
    if ( $data{done} ne "Yes" && $data{duedate} ne "none" )
      {
      # check over-due items
      my $now = `date +%s`;
      my $then = `date --date "$data{duedate}" +%s`;
      $red = "color=#cc0000" if $now > $then;
      my $due = int( ( $now - $then ) / ( 24 * 60 * 60 ) + 0.5 );
      $duedays = "<br><font size=-1>$due day(s) over-due</font>" if  $now > $then;
      }

    my $icon = ( $data{done} eq "No" ) ? "<-img:todo-on>" : "<-img:todo-off>";
  
    my $cat_e = CGI::escape( $data{ category } );
    my $cat_link = "<a href=?act=list&cat=$cat_e>$data{ category }</a>";
    
    my $title = $data{title} || '[unnamed]';
    push @td, [ "<a href='?act=toggle&id=$id'>$icon</a>",
                "<font $red><b>$data{priority}</b></font></b>",
                "<a href=?act=view&id=$id><font $red><b>$title</b></font></a>
                 <font size=-1 $red>$note_reminder $duedays</font>",
                 $cat_link,
                 "<font $red><b>$data{duedate}</b></font>" ];
    }

  $text .= html_format_table( \@td, opt => "width=100% cellspacing=1" ) . "
    <p>
    <hr noshade size=1 width=80%>
    <center>
    <a href=?act=form&id=0 class=button>  New  </a>
    </center>
  ";

  return $text;
};

##############################################################################

sub form_item
{
  my $text;
  
  my $id = $SDA{ "in_id" };
  
  my %data = ();
  
  load_hash( $id, \%data );
  
  $data{priority} = 3 unless $data{priority};
  $data{done} = "No" unless $data{done};
  $data{category} = $CAT unless $data{category};

  my $s_dm;
  my @s_pri;

  $s_pri[$data{priority}] = "selected";

  my $now_str = `date +"%b %d %Y"`;

  my $duedate_str;
  if ( $id == 0 )
    {
    $data{duedate} = `date +"%b %d %Y"` ;
    }
  else
    {
    if ( $data{duedate} eq "none" )
      {
      $duedate_str = "none"
      }
    else
      {
      $duedate_str = `date -d "$data{duedate}" +"%b %d %Y"`;
      $s_dm = "selected";
      }
    }

  my @td;

  my $cats_list = get_cats_option_list( $data{ category } );

  push @td, [ "[!width=30% align=right]Attribute", "[!width=70%]Value" ];
  push @td, [ "<b>Title:",
              "<input name=title value='$data{title}' size=40>" ];
  push @td, [ "<b>Priority:",
              "<b>
               <select name=priority>
                 <option value=0 $s_pri[6]>0 - URGENT!</option>
                 <option value=1 $s_pri[1]>1 - Highest</option>
                 <option value=2 $s_pri[2]>2 - High</option>
                 <option value=3 $s_pri[3]>3 - Medium</option>
                 <option value=4 $s_pri[4]>4 - Low</option>
                 <option value=5 $s_pri[5]>5 - Lowest</option>
               </select>" ];
  push @td, [ "<b>Category:",
              "<b><select name=category>$cats_list</select>" ];
  push @td, [ "<b>Due date:",
              "<b>
               <select name=duemodifier>
                 <option value='none'>No date</option>
                 <option value='+0'>Today</option>
                 <option value='+1'>Tomorrow</option>
                 <option value='+7'>One week later</option>
                 <option value='+30'>30 days later</option>
                 <option value='fixed' $s_dm>Fixed date:</option>
               </select>
               <input name=duedate value='$data{duedate}' size=15>" ];
  push @td, [ "<b>Done:", 
              "<b><-select:done:$data{done}:$data{done}:Yes:Yes:No:No>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Today is: $now_str" ];
  push @td, [ "<b>Notes:",
              "<textarea name=note rows=6 cols=40>$data{note}</textarea>" ];

  my $cancel = $id == 0 ? "act=list" : "act=view&id=$id";
  $text .= "
    <center>
    <form action=?>
    <input type=hidden name=id   value=$id>
    <input type=hidden name=act  value=update>"
    . html_format_table( \@td, opt => "width=80% cellspacing=1" ) .
    "
    <hr noshade size=1 width=80%>
    <input type=submit value='  Done  ' class=button>
    <a href='?$cancel' class=button> Cancel </a>
    <a href='?act=delete&id=$id' class=button>  Delete  </a>
    </form>
    ";

  return $text;
};

##############################################################################

sub update_item
{
  my $id = $SDA{ "in_id" };
  $id = new_id() if $id == 0;

  my %data;
  for( qw( priority category duedate done title note ) )
    {
    $data{ $_ } = $SDA{ "in_$_" };
    }
  $data{ title } ||= "[unnamed]";

  return "Invalid priority!"    unless $data{priority} =~ /^[0123456]$/;
  return "Invalid done field!"  unless $data{done} =~ /^(Yes)|(No)$/;
  return "Invalid due date!"    unless $data{duedate} =~ /^([a-zA-Z]{3} \d{1,2} \d{4})|(none)$/;

  my $duemodifier = $SDA{ "in_duemodifier" };

  return "Invalid due date modifier!" unless $duemodifier =~ /^(none)|(fixed)|(\+\d+)$/;

  if ( $duemodifier =~ /^\+(\d+)$/ )
    { $data{duedate} = `date -d "$1 days" +"%b %d %Y"` }
  elsif ( $duemodifier eq "none" || $data{duedate} eq "none" ) # second one is just to keep clear
    { $data{duedate} = "none" }
  else
    { $data{duedate} = `date -d "$data{duedate}" +"%b %d %Y"` }

  $data{duedate} = "none" if  $data{priority} == 6;  # no duedate for EXTREMELY URGENT items!

  $data{ "find_title" } = $data{ title }; # see find module notes!
  save_hash( $id, \%data );

  $SDA{ "in_id" } = $id;
  return view_item();
};

##############################################################################

sub view_item
{
  my $text;
  
  my $id = $SDA{ "in_id" };
  
  my %data;
  load_hash( $id, \%data );

  my $notes = rtf_text( $data{note} );
  
  my @td;
  
  push @td, [ "=<b>Category: $data{category}" ];
  push @td, [ "<b>Title:",
              "<b>$data{title}" ];
  push @td, [ "<b>Priority",
              "<b>$data{priority}" ];
  push @td, [ "<b>DueDate",
              "<b>$data{duedate}" ];
  push @td, [ "<b>Done",
              "<b>$data{done}" ];
  push @td, [ "<b>Notes:",
              "<pre>$notes" ];
  
  $text .= "
    <center>"
    . fmt_table( @td, { width => "80%", 
                        right1 => "hack" } ) .
    "
    <hr noshade size=1 width=80%>
    <a href='?act=list' class=button>   Ok   </a>
    <a href='?act=form&id=$id' class=button>  Edit  </a>
    ";
  
  return $text;
}

##############################################################################

sub toggle_item
{
  my $text;
  
  my $id = $SDA{ "in_id" };
  
  my %data = ();
  
  load_hash( $id, \%data );
  if ( $data{done} eq "No" )
    {
    $data{done} = "Yes"
    }
  else
    {
    $data{done} = "No"
    }
  save_hash( $id, \%data );
  
  return list_items();
};

##############################################################################

sub delete_item
{
  my $id = $SDA{ "in_id" };
  system( "mv $id deleted/$id" );
  return list_items();
};

1;

