##############################################################################
#
#  Palm-FE Palm Pilot Functional Emulator
#  (c) Vladi Belperchinov-Shabanski "Cade" 2000-2001 
#  <cade@biscom.net> <cade@datamax.bg>
#
#  DISTRIBUTED UNDER GPL LICENSE, SEE `COPYING' FILE FOR DETAILS
#
##############################################################################
package p3_ses;
use Exporter;
$VERSION = 1.00;
@ISA     = qw( Exporter );
@EXPORT  = qw( http_sid http_user );
use strict;
use p3_conf;
use p3_uti;

use CGI::Cookie;
use CGI;

#############################################################################

my $hph             = "Content-type: text/html\nPragma: no-cache\n\n
                      <html>
                      <link rel=stylesheet href=$WWWPATH/$THEME/base.css type=text/css>
                      <body>
                      <br><br><br><br>
                      <div align=center>
                      <table border=0 cellpadding=20><tr><td bgcolor=$TC2><div align=center>
                      <h2><code>
                      ";
my $hpf             = "</code></h2></div></td></tr></table></div></body></html>";
my $http_login_page = "$hph
                      <form action=? method=post>
                      Login for [\$DOMAIN]<br><br>
                      <hr noshade size=2>
                      <table>
                      <tr>
                        <td>Username:</td><td><input name=username></td>
                      </tr>
                      <tr>  
                        <td>Password:</td><td><input name=password type=password></td>
                      </tr>
                      </table>
                      <input type=submit value='   Login   ' class=button>
                      </form>
                      $hpf
                      ";
my $http_bad_login_page = "$hph
                      <form action=? method=post>
                      Login for [\$DOMAIN]<br><br>
                      <hr noshade size=2>
                      <font color=#ff0000>Bad username or password</font><br><br>
                      <table>
                      <tr>
                        <td>Username:</td><td><input name=username></td>
                      </tr>
                      <tr>  
                        <td>Password:</td><td><input name=password type=password></td>
                      </tr>
                      </table>
                      <input type=submit value='   Login   ' class=button>
                      </form>
                      $hpf";
my $http_login_ok   = "$hph
                      Login for [\$DOMAIN] OK<p>
                      <hr noshade size=2>
                      Your last login was at<br>[lasttime]<p>
                      You came from [lastaddr]<p>
                      <a href=[url]>Click here to proceed</a>
                      $hpf";
my $http_error      = "$hph
                      Login for [\$DOMAIN]<p>
                      <hr noshade size=2>
                      Error encountered,<br>possible reasons are:<p>
                      <li>Authorization file not found<p>
                      <li>Session expired<p>
                      <li>Wrong session id<p>
                      <a href=?>Login here</a>
                      $hpf";

my $logfile;
my $histfile;

#############################################################################

my $SESLETTERS = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';

sub http_sid
{
  # logger( "http_sid: " . CGI::cookie( "p3_sid" ) );
  return CGI::cookie( "p3_sid" );
}

sub http_user
{
  my %arg = @_;
  my $domain     = $arg{ 'DOMAIN'     } || "unknown";
  my $sespath    = $arg{ 'SES_PATH'   } || "/tmp";
  my $passwdfile = $arg{ 'PWD_FILE'   } || "/dev/null";
  my $idletime   = $arg{ 'IDLE_TIME'  } || 3600; # 1 hour default

  $http_bad_login_page =~ s/\[\$domain\]/$domain/gi;
  $http_login_page     =~ s/\[\$domain\]/$domain/gi;
  $http_login_ok       =~ s/\[\$domain\]/$domain/gi;
  $http_error          =~ s/\[\$domain\]/$domain/gi;
  $domain              =~ s/[^a-z0-9\-_]/_/gi;

  my $sid = http_sid();
  logger( "p3_ses: sid: $sid" );

  my $username = CGI::param( "username" );
  my $password = CGI::param( "password" );

  if ( ! -r $passwdfile )
    {
    print $http_error;
    exit;
    }

  my $nocookie = new CGI::Cookie( -name=>'p3_sid',
                                  -value => 0 );
  $nocookie = "Set-Cookie: $nocookie\n";

  debug( "NO-COOKIE setup: $nocookie" );

  if ( ! $sid )
    {
    logger( "p3_ses: user: $username, pass: $password" );
    if ( ! $username && ! $password )
      {
      print $http_login_page;
      debug('*** p3_ses: no user, no pass, no sid--login');
      exit;
      }

    my %pass_data;
    load_hash( $passwdfile, \%pass_data );

    # check password here...
    my $passok = $pass_data{ $username } eq $password;

    debug( "p3_ses: PASSOK: $passok?" );

    if ( $passok )
      {
      # clean concurent user sessions
      for my $sesfile ( glob( "$sespath/http_ses_[0-9]*" ) )
        {
        my %data;
        load_hash( $sesfile, \%data );
        
        if ( $username eq $data{ username } && time() - $data{ atime } > $idletime )
           { 
           unlink $sesfile; 
           }
        }
      
      my $l = length( $SESLETTERS );
      while(4)
        {                       
        $sid = "";
        for( 1..24 ) { $sid .= substr( $SESLETTERS, int(rand() * $l), 1 ); }
        last unless -e "$sespath/http_ses_$sid";  
        }
          
      my %data;
      $data{ username } = $username;
      $data{ logintime } = time();
      $data{ atime } = time();
      $data{ domain } = $domain;
      save_hash( "$sespath/http_ses_$sid", \%data );
      logger( "login ok, $username, $domain" );
      
      my $cookie = new CGI::Cookie( -name=>'p3_sid',
                                    -value => $sid );
  
      debug( "SET-COOKIE setup: $cookie" );
      # FIXME: Location https???
      print "Set-Cookie: $cookie\nLocation: ?\n\n";
      exit;
      }
    else
      {
      print $nocookie . $http_bad_login_page;
      logger( "bad login, $username, $domain" );
      exit;
      }
    }
  else
    {
    my $sidfile = "$sespath/http_ses_$sid";
    if ( ! -r $sidfile )
      {
      print $nocookie . $http_error;
      logger( "non-existent session requested" );
      exit;
      }
    else
      {
      my %data;
      my $userok;
      load_hash( "$sespath/http_ses_$sid", \%data );
      if ( time() - $data{ atime } > $idletime )
        {
        unlink $sidfile;
        print $nocookie . $http_error;
        logger( "session expired, $data{ username }, $domain" );
        exit;
        }
      if ( $username eq "logout" )
        {
        unlink $sidfile;
        print $nocookie . $http_login_page;
        logger( "logout, $data{ username }, $domain" );
        exit;
        }
      if ( $data{ username } eq "" )
        {
        unlink $sidfile;
        print $nocookie . $http_error;
        logger( "bad session data, user unknown" );
        exit;
        }
      $data{ atime } = time();
      $userok = $data{ username };
      save_hash( "$sespath/http_ses_$sid", \%data );
      return $userok;
      }
    }
  print $nocookie . $http_error;
  logger( "unknown error" );
  exit;
}

#############################################################################

1;
