##############################################################################
#
#  Palm-FE Palm Pilot Functional Emulator
#  (c) Vladi Belperchinov-Shabanski "Cade" 2000-2001 
#  <cade@biscom.net> <cade@datamax.bg>
#
#  DISTRIBUTED UNDER GPL LICENSE, SEE `COPYING' FILE FOR DETAILS
#
##############################################################################
package p3_uti;
use CGI;
use p3_conf;
use Exporter;
@ISA    = qw( Exporter );
@EXPORT = qw( load_module
              pipe_image html_expand fmt_table fmt_table2 
              html_format_table
              fmt_header fmt_footer 
              edit_categories 
              get_cats_option_list 
              new_id
              rtf_text
              rtf_clean
              rtf_note_reminder
              load_dir
              mkpath check_dir
              save_hash load_hash
              logger
              debug
              );
use strict;

#############################################################################
#
#
#

sub pipe_image
{
  my $name = shift;
  $name =~ s/[^a-z\-\.0-9]//gio;
  local $/ = "";
  my $text = "Content-type: image/gif\n\n";
  open( i, "$ROOT/themes/$THEME/$name" );
  $text .= <i>;
  close( i );
  return $text;
}

##############################################################################
#
#
#

sub load_module
{
  my $MODE = uc shift;

  if( $MODE )
    {
    my $module = lc "p3_mod_$MODE";
    if ( -r "$ROOT/pro/$module.pm" )
      {
      require "$ROOT/pro/$module.pm";
      no strict;
      $MODULES{ "\u\L$MODE" } = \%{ "$module\::OPT" };
      }
    }
  else
    {
    for my $m ( glob( "$ROOT/pro/p3_mod_*.pm" ) )
      {
      next unless $m =~ /\/p3_mod_(\S+?).pm$/;
      load_module( uc $1 );
      }
    }    
}

#############################################################################
#
#
#

=pod

<-form:method:action>
<-select:name:item1:value1:item2:value2:item3:value3>
<-input:name:length:value>
<-hidden:name:length:value>
<-subimg:name>
<-check:name:1>
<-endf>
<-img:name>

=cut

sub html_expand
{
  $_ = join "", @_;
  s/<-([^>]+)>/tagexp($1)/gie;
  
  # to be a bit more compliant :)
  s|<center>|<div align=center>|gio;
  s|</center>|</div>|gio;
  s|<left>|<div align=left>|gio;
  s|</left>|</div>|gio;
  s|<right>|<div align=right>|gio;
  s|</right>|</div>|gio;
  s/(href|src)=~/$1=$WWWPATH/gi;
  return $_;
}  

sub tagexp
{
  my @arg = split /:/, shift;
  my $type = shift @arg;
  if ( $type eq "form" )
    {
    return "<form method=$arg[0] action=$arg[1] >";
    }
  elsif( $type eq "endf" )
    {
    return "</form>";
    }  
  elsif( $type eq "select" )
    {
    my $name = shift @arg;
    my $r = "<select name=$name>\n";
    my $pad = '&nbsp;' x 5;
    while( $#arg > -1 )
      {
      $r .= "<option value='" . shift( @arg ) . "'>" . shift( @arg ) . "$pad</option>\n";
      }
    $r .= "</select>";
    return $r;
    }  
  elsif( $type eq "input" )
    {
    return "<input name=$arg[0] size=$arg[1] value='$arg[2]' >";
    }  
  elsif( $type eq "hidden" )
    {
    return "<input type=hidden name=$arg[0] size=$arg[1] value='$arg[2]' >";
    }  
  elsif( $type eq "check" )
    {
    my $ck = "checked" if $arg[1] > 0;
    return "<input type=checkbox name=$arg[0] $ck>";
    }  
  elsif( $type eq "img" )
    {
    if( $WWWPATH )
      {
      return "<img src='$WWWPATH/$THEME/$arg[0].gif' border=0>";
      }
    else
      {
      return "<img src='?pipeimg=$arg[0].gif' border=0>";
      }  
    }  
  elsif( $type eq "subimg" )
    {
    if( $WWWPATH )
      {      
      return "<input type=image src='$WWWPATH/$THEME/$arg[0].gif' border=0>";
      }
    else
      {
      return "<input type=image src='?pipeimg=$arg[0].gif' border=0>";
      }  
    }  
}

#############################################################################
#
#
#

sub fmt_table(\@;$)
{
  my $arr = shift;
  my $opt = shift;
  my $opt_width = $$opt{ width } || "100%";
  my $opt_cellpadding = exists $$opt{ cellpadding } ? $$opt{ cellpadding } : "4";
  my $text = "<table width=$opt_width cellspacing=1 cellpadding=$opt_cellpadding bgcolor=$BGC >\n";
  my $r = 2;
  for( @$arr )
    {
    my $arr_int = $_;
    my $c = ($r == 2) ? 'trh' : ( $r ? 'tr2' : 'tr1' );
    $text .= "<tr class=$c>";
    my $opt_right1 = $$opt{ right1 } ? "align=right" : "align=left";
    for( @$arr_int )
      {
      $_ .= "&nbsp;";
      if (/^\+/)
        { s/^\+//; $text .= "<td width=100% $opt_right1>$_</td>"; }
      elsif(/^\=/)
        { s/^\=//; $text .= "<td colspan=2 $opt_right1>$_</td>"; }
      else
        { $text .= "<td $opt_right1>$_</td>"; }  
      $opt_right1 = undef;
      }
    $text .= "</tr>\n";   
    $r = !$r;
    }
    
  $text .= "</table>\n";
  return $text;
}

sub fmt_table2(\@;$)
{
  my $arr = shift;
  my $opt = shift;
  my $opt_width = $$opt{ width } || "100%";
  my $opt_cellpadding = exists $$opt{ cellpadding } ? $$opt{ cellpadding } : "4";
  my $text = "<table width=$opt_width cellspacing=1 cellpadding=$opt_cellpadding>\n";
  for( @$arr )
    {
    my $arr_int = $_;
    $text .= "<tr>";   
    my $opt_right1 = $$opt{ right1 } ? "align=right" : "align=left";
    for( @$arr_int )
      {
      $_ .= "&nbsp;";
      if (/^\+/)
        { s/^\+//; $text .= "<td width=100% $opt_right1>$_</td>"; }
      elsif(/^\=/)
        { s/^\=//; $text .= "<td colspan=2 $opt_right1>$_</td>"; }
      else
        { $text .= "<td $opt_right1>$_</td>"; }  
      $opt_right1 = undef;
      }
    $text .= "</tr>\n";   
    }
    
  $text .= "</table>\n";
  return $text;
}

#############################################################################
#
#
#

sub html_format_table
{
  my $data = shift;
  my %opt = @_;
  
  my $text;
  
  my $trclass1 = $opt{ 'tr-class-1' } || 'tr1';
  my $trclass2 = $opt{ 'tr-class-2' } || 'tr2';
  
  my %CACHE;
  
  my $row = 0;
  $text .= "<table $opt{opt}>\n";
  for my $vr ( @$data )
    {
    $row++;
    my $trclass;
    if ( $vr->[0] =~ s/^\{([a-z0-9\-]+)\}//i )
      { $trclass = $1; }
    else  
      { $trclass = $row % 2 ? $trclass1 : $trclass2; }
    $trclass = 'trh' if $row == 1;
    
    my $col = 0;
    $text .= "<tr class=$trclass>";
    for my $vc ( @$vr )
      {
      my $class = " class=$1" if $vc =~ s/^\[([a-z0-9\-]+)\]//i;
      my $args;
      if( $vc =~ s/^\[!([^\[\]]+)\]//i )
        {
        $args = " $1";
        $CACHE{"COL:ARGS:$col"} = $args;
        }
      else
        {
        $args = $CACHE{"COL:ARGS:$col"};
        }
      $text .= "<td$class$args>$vc</td>";
      $col++;
      }
    $text .= "</tr>\n";
    }
  $text .= "</table>\n";
  
  return $text;
}

#############################################################################
#
#
#

sub fmt_header
{
    my $title = shift;

    my $text;
     
    $text .= "Content-type: text/html\n\n";
    
    $text .= "
    <html>
    <title>Palm-FE: \u$USER &raquo; $title</title>
    <link rel=stylesheet href=~/$THEME/base.css type=text/css>
    <body>
    <center>
    <table width=90%>
    <tr>
    <td>
    <!------------------------------------------>
    
      <-form:GET:>
      <table width=100% cellspacing=0>
      <td width=5% class=mode>
        <img src=~/$THEME/empty.gif width=40 height=40>
      </td>
      <td width=45% class=mode>
        <a class=mode href=?mode=UserInfo>\u$USER</a> &raquo; $title
      </td>
      <td bgcolor=$BGC width=50% align=right>
        <font color=$FGC>
    ";
    
    if ( $MODULES{ $MODE }{ cats } )
      {
      $text .= "
        <!----------------------------------------------------------->
        <b><select name=cat  onchange='submit()'>
        ";
    
      my @cats = sort keys %CATS;
      push @cats, 'All', 'Unfiled', 'Edit Categories';
      for( @cats )
        {
        my $s = "selected" if $_ eq $CAT;
        my $pad = '&nbsp;' x 5;
        $text .= "<option $s value='$_'>$_$pad</option>";
        }
      
      $text .= "
        </select>
        <input type=submit value=Go class=button></b>
        <!----------------------------------------------------------->
        ";
      }
    else
      {
      $text .= "&nbsp;"; # not required really but just to be sure
      }
    
      $text .= "
        </font>
      </td>
      </table>
      <hr noshade size=2>
      </form>
    
    <!-------------------------------------------------------------->
    </td>
    </tr>
    <tr>
    <td align=center>
    <!--=== header end ===========================================-->
    ";
    
    return $text;
}


sub fmt_footer
{
    my $text;
    
    $text .= "
    <!--=== footer start =========================================-->
    </td>
    <tr>
    <td width=100%>
    <hr noshade size=2>
    <center>
    <table>
    ";
    for my $m ( @MODULES )
      {
      my $i = lc $m;
      $text .= "
        <td>
        <center>
        <a href=?mode=$m&act=list><-img:$i><br><b>$m</b></a>
        </center>
        </td>
        ";
      }
    $text .= "
        <td>
        <center>
        <a href=?username=logout><-img:logout><br><b>Logout</b></a>
        </center>
        </td>
    </table>
    <code><b>" . scalar(localtime()) . "</b><br>
    <small><a href=http://cade.datamax.bg/away/palm-fe>Palm-FE</a> (c) Vladi Belperchinov-Shabanski 2000-2001 &lt;cade\@datamax.bg&gt;</small>
    </code>
    </center>
    
    </td>
    </table>
    </center>
    
    <!--=== footer end ===========================================-->
    </body>
    </html>
    ";
    
    return $text;
}

#############################################################################
#
#
#

sub edit_categories
{
  my $text;
  
  my $addcat = $SDA{ "in_addcat" };
  my $delcat = $SDA{ "in_delcat" };
  
  $addcat = "\u$addcat";
  
  undef $addcat if $addcat =~ /^(Edit)|(All)|(Unfiled)$/;
  undef $delcat if $delcat =~ /^(Edit)|(All)|(Unfiled)$/;
  undef $addcat if $addcat =~ /^\s*$/;
  
  $CATS{ $addcat } = 1 if $addcat;
  delete $CATS{ $delcat } if $delcat;
  
  save_hash( $CATFILE, \%CATS );
  
  my @td;
  push @td, [ "+<b>Category name", "<b>Operation" ];
  
  for( sort keys %CATS )
    {
    my $i = $_;
    my $ei = CGI::escape( $i );
    push @td, [ "<b><a href=?cat=$ei>$i</a></b>", 
                "<a href=?cat=Edit&delcat=$ei class=button>Delete</a>" ];
    }
  
  $text .= "<form action=?>"
    . fmt_table( @td ) .
    "<p>
     <center>
     <input type=hidden name=cat  value=Edit>
     <input name=addcat size=30>
     <input type=submit value='Add Category' class=button>
     </form>
     </center>
    ";
  
  return $text;  
};

#############################################################################
#
#
#

sub get_cats_option_list
{
  my $this_cat = shift;
  my $cats_list;
  my @cats = sort keys %CATS;
  push @cats, "Unfiled";
  for( @cats )
    {
    my $s;
    if ( $this_cat )
      { $s = "selected" if $_ eq $this_cat; }
    else
      { $s = "selected" if $_ eq $CAT; }  
    my $pad = '&nbsp;' x 5;
    $cats_list .= "<option $s value='$_'>$_$pad</option>";
    }
  return $cats_list;
}

#############################################################################
#
#
#

sub new_id
{
  my $id = time();
  while( -e $id ) { sleep(1); $id = time(); }
  return $id;
}

#############################################################################
#
#
#

sub rtf_text
{
  my $text = shift;
  $text =~ s|\*(\S+)\*|<b>$1</b>|gio;
  $text =~ s|\_(\S+)\_|<i>$1</i>|gio;
  $text =~ s|([a-z]+://\S+)|<a href="$1">$1<\/a>|gio;
  $text =~ s|(\S+\@\S+)|<a href="mailto:$1">$1<\/a>|gio;
  return $text;
}

sub rtf_clean
{
  my $text = shift;
  $text =~ s|\*(\S+)\*|$1|gio;
  $text =~ s|\_(\S+)\_|$1|gio;
  return $text;
}

sub rtf_note_reminder
{
  my $text = substr(rtf_clean( shift ), 0, 48);
  return undef unless $text;
  return "<br>$text....."  
}

#############################################################################
#
#
#

sub load_dir
{
  my $dir = shift;
  my $re  = shift;
  my @data;
  
  opendir(d,$dir) or return @data;
  @data = readdir(d);
  closedir(d);
  @data = grep { /$re/ } @data if $re;
  return @data;
}

##############################################################################
#
#
#

sub mkpath
{
  my $path = shift;
  my $mask = shift || oct('700');
  my $abs;

  $path =~ s/\/+$/\//o;
  $abs = '/' if $path =~ s/^\/+//o;

  my @path = split /\/+/, $path;

  $path = $abs;
  for my $p ( @path )
    {
    $path .= "$p/";
    next if -d $path;
    mkdir( $path, $mask ) or return 0;
    }
  return 1;
}

##############################################################################
#
#
#

sub check_dir
{
  my $dir = shift;
  my %opt = @_;

  mkpath( $dir, $opt{ 'MASK' } ) unless -d $dir;
  if( ! -d $dir )
    {
    die "check_dir: cannot find dir $dir\n" if $opt{ 'FATAL' };
    return undef;
    }
  return $dir;
}

##############################################################################
#
#
#

sub html_inc_file
{
  my $name = lc shift;
  my $html;
  for my $p ( @HTML_INC )
    {
    my $f = "$p/$name.html";
    next unless -e $f;
    #DEBUG( "html_inc_file: $f" );
    $html = load_file( $f );
    last;
    }
  $html =~ s/\[\#(\S+)\]/html_inc_file( $1 )/ge;
  return $html;
}

sub html_preprocess
{
  my $file = shift || 'index';
  
  my %DATA = %ENV;
  
  my $html = html_inc_file( $file );
  
  $html =~ s/\[\$(\S+)\]/$DATA{ $1 }/g;
  $html =~ s/(src|href)=~/$1=$WWWPATH\/$THEME\/img\//gio;
  $html =~ s/\[T\:([^\]]*)\]/$TRANSLATION->{ $1 }||$1/gie; # \: is to avoid get_trans.pl
  
  return $html;
}

sub load_file
{
  my $file = shift;
  open( my $i, $file ) or return undef;
  local $/ = undef;
  my $s = <$i>;
  close $i;
  return $s;
}

sub save_file
{
  my $file = shift;
  open( my $o, ">$file" ) or return undef;
  print $o @_;
  close( $o );
  return 1;
}

##############################################################################
#
#
#

sub save_hash
{
  my $name = shift;
  my $data = shift;
  open( o, ">" . $name );
  for( keys %$data )
    {
    my $k = $_;
    my $d = $data->{ $k };
    $d =~ s/\n/\\n/g;
    print o "$k=$d\n"; 
    }
  close( o );
}

##############################################################################
#
#
#

sub load_hash
{
  my $name = shift;
  my $data = shift;
  open( i, $name );
  while(<i>)
    {
    chop;
    $data->{ $1 } = $2 if ( /^([^=]+)=(.+)$/ );
    $data->{ $1 } =~ s/\\n/\n/g;
    }
  close( i );
}

##############################################################################
#
#
#

sub logger
{
  print STDERR join '', "palm_fe3 [$$] ", @_, "\n";
}

sub debug
{
  return unless $DEBUG;
  logger( 'DEBUG: ', @_ );
}

#############################################################################

1;
